/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.logd;

import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.log.LogBlock;
import com.ibm.hwmca.fw.logd.DisplayerExpanderData;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.HexString;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;

public abstract class DisplayerExpander
extends PanelTasklet {
    private static final String TRACE_MASKT = "XLOGDEXT";
    private static final String TRACE_MASKD = "XLOGDEXD";
    private static final String TRACE_MASKF = "XLOGDEXF";
    DisplayerExpanderData _displayerExpanderData;
    PanelTasklet _panelTasklet;

    public void service(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> DisplayerExpander.getData()");
        Log logData = (Log)taskletRequest.getData("logObject");
        LogBlock logBlock = (LogBlock)taskletRequest.getData("logBlockObject");
        this._displayerExpanderData = new DisplayerExpanderData();
        this._displayerExpanderData.setLogData(logData);
        this._displayerExpanderData.setLogBlock(logBlock);
        byte logClass = logData.getLogClass();
        String logClassStr = HexString.toHex(logClass, true).toUpperCase();
        byte logType = logData.getLogType();
        String logTypeStr = HexString.toHex(logType, true).toUpperCase();
        byte logBlockId = logBlock.getBlockId();
        String logBlockIdStr = HexString.toHex(logBlockId, true).toUpperCase();
        Trace.trace(TRACE_MASKF, "Displayer processing logClass=" + logClassStr + " logType=" + logTypeStr + " blockId=" + logBlockIdStr);
        byte[] hexData = (byte[])logBlock.getData();
        this._displayerExpanderData.setHexData(hexData);
        if (hexData == null || hexData.length == 0) {
            Trace.trace(TRACE_MASKF, "There is no block data to display");
            LocalizableText lBlkTitle = new LocalizableText(BaseTextBundle.getBundleName(), "logd.blockdata.title");
            BaseMessageText myMess = new BaseMessageText("LOGNODATA");
            this.showMessageBox(true, lBlkTitle, myMess, null, null);
            taskletResponse.dispose();
        }
        Trace.trace(TRACE_MASKT, "<- DisplayerExpander.getData()");
    }

    public DisplayerExpanderData getData() {
        return this._displayerExpanderData;
    }
}

